# This program demonstrates the basic structure of a Match Case.

def main():
    # Just so we can have our program do something later, let's
    # create a list with some data.
    myList = ["Apple", "Orange", "Grapefruit"]

    # I'd like this program to run until more or less indefinitely,
    # so let's create an infinite loop. This loop will act as our
    # menu. Don't worry, we'll provide a way to get out of this loop
    # later.
    while True:
        # Let's print out a simple menu.
        print("1: View my list")
        print("2: Quit")

        # Now let's get the user's choice, convert it into an integer,
        # and store it in a suitable variable.
        choice = int(input("Your choice? "))

        # Now we'll try to match the user's choice with a case. We can
        # either execute additional code within the case, or we could
        # call a function containing the code we'd like to execute.
        # Because I'm lazy, I'm just going to execute code right inside
        # each case. Note that we're trying to match the number entered
        # by the user with a numbered case. You could also design a
        # match statement to match a string instead. Why not try changing
        # the menu options above to "A" and "B" and modify the Input
        # and Match Case statements accordingly?
        match choice:
            case 1:
                print(myList)
            case 2:
                print("Goodbye!")
                # I told you we'd provide a way out of our infinite loop!
                # The Break statement will immediately terminate the loop.
                # If we had additional code following the loop, it would
                # be executed next.
                break
            # Here's a special case. The _ will always match, so if your
            # Match Case includes this case, it should always be last.
            # Here, I'm using this case to catch for invalid menu choices.
            case _:
                print("Invalid choice.")
                
if __name__=='__main__':
    main()